/*{
	"GUID":"83A3EBFF-0A46-465b-B201-1E8A7DD5DA1B",
  "PARAMS":[
    {
      "NAME":"swing",
      "TYPE":"float",
      "DEFAULT":0.3,
      "MIN":0.0,
      "MAX":1.0
    },
    {
      "NAME":"frequency",
      "TYPE":"float",
      "DEFAULT":0.41,
      "MIN":0.0,
      "MAX":1.0
    },{
		"NAME":"alpha",
		"TYPE":"int",
		"DEFAULT":100,
		"MIN":0,
		"MAX":100
	}
  ]
}*/


 
#define FILTER_PI 3.1415926

vec4 FUNCNAME(vec2 tc) 
{ 
 
    int alpha = PREFIX(alpha);  
    vec2 ttwo = 2.0/iResolution.xy;
    vec4 col;
    vec2 scaleFragCoord =  tc * iResolution.xy;

    float fre = PREFIX(frequency)/0.2*FILTER_PI/iResolution.x;

    float y = scaleFragCoord.y + PREFIX(swing) * 100.0 * iResolution.y /360.0 * sin(fre * scaleFragCoord.x);
    

    if(y < 0 || y >= iResolution.y) 
    {
      col = vec4(0.0, 0.0, 0.0, 1.0);
    }    
    else
    {         
        vec2 uv = vec2(scaleFragCoord.x / iResolution.x, (scaleFragCoord.y/iResolution.y + y )/ iResolution.y);
        float featherX = smoothstep(0.0,ttwo.x,uv.x) * (1.0 - smoothstep(1.0-ttwo.x,1.0,uv.x));
        float featherY = smoothstep(0.0,ttwo.y,uv.y) * (1.0 - smoothstep(1.0-ttwo.y,1.0,uv.y));
        col = INPUT(uv)  * featherX * featherY;
    }

    vec4 orig =  INPUT(tc);
    return mix(vec4(col.rgb, orig.a), orig, 1.0 - float(alpha)/100.0);
}

